from django.contrib import admin
from django.urls import include, path
from django.contrib.auth import views as auth_views
from django.views.generic.base import TemplateView
from accounts import views as user_views
from frontend import views as frontend_views
from advertising import views as adviews
from backend import views as backend_views
from django.conf import settings
from django.conf.urls.static import static
from django.views.static import serve

from django.urls import reverse

from django.views.generic.base import RedirectView

from accounts.views import indexRedirectView

urlpatterns = [
    path('', user_views.indexview),

    # Frontend Shop
    path('article/<int:productid>/', user_views.article_detail, name='article_detail'),

    # Aff Link
    path('t/<str:affid>/', frontend_views.afflinatecookie, name='afflinateCookie'),

    # APIs
    path('api/', include('api.urls', namespace='api')),

    # Auth
    path('resendhandler/', user_views.resendhandler, name='resendhandler'),
    path('verificationhandler/', user_views.verificationhandler, name='verificationhandler'),
    path('register/', user_views.register, name='register'),
    path('third/register/', user_views.thirdpartyregister, name='thirdpartyregister'),

    path('welcome/getstarted/register', user_views.getstartedregister, name='getstartedregister'),
    path('welcome/getstarted/login', user_views.getstartedlogin, name='getstartedlogin'),
    path('welcome/phonestart/', user_views.phonestart, name='phonestart'),
    path('registerchip/', user_views.registerchip, name='registerchip'),

    path('auth/thirdlogin/', user_views.thirdlogin, name='thirdlogin'),

    path('logout/', user_views.logoutview, name='logout'),

    # Shop templates
    path('shop/', include('shop.urls', namespace='shop')),

    # User Backend
    path('', include('backend.urls', namespace='backend')),

    # User Frontend
    path('', include('frontend.urls', namespace='frontend')),

    # Admin
    path('admin/', admin.site.urls),

] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

handler400 = 'frontend.views.badrequest'
handler403 = 'frontend.views.permissions'
handler404 = 'frontend.views.notfound'
handler500 = 'frontend.views.error'

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
