$(document).ready(function () {
const html = document.documentElement;
const canvas = document.getElementById("tapped-apps");
const context = canvas.getContext("2d");

const frameCount = 51;
const currentFrame = index => (
  `https://tapped.to/static/img/tapped-apps/0${index.toString()}.png`
)

const preloadImages = () => {
  for (let i = 1; i < frameCount; i++) {
    const img = new Image();
    img.src = currentFrame(i);
  }
};

const img = new Image();
img.src = currentFrame(1);
canvas.width=400;
canvas.height=300;

    var scale = Math.min(canvas.width / img.width, canvas.height / img.height);
    // get the top left position of the image
    var x = (canvas.width / 2) - (img.width / 2) * scale;
    var y = (canvas.height / 2) - (img.height / 2) * scale;

img.onload=function(){
  context.drawImage(img, x, y, img.width * scale, img.height * scale);
};

const updateImage = index => {


    var scale = Math.min(canvas.width / img.width, canvas.height / img.height);
    // get the top left position of the image
    var x = (canvas.width / 2) - (img.width / 2) * scale;
    var y = (canvas.height / 2) - (img.height / 2) * scale;

  img.src = currentFrame(index);
  context.drawImage(img, x, y, img.width * scale, img.height * scale);
};

window.addEventListener('scroll', () => {
        $('#tapped-apps').each(function (i) {
        var bottom_of_object = $(this).offset().top + $(this).outerHeight();
        var bottom_of_window = $(window).scrollTop() + $(window).height();
        
		
		//if (bottom_of_window > bottom_of_object) {
            const scrollTop = html.scrollTop;


            // window.innerHeight = Browserhöhe
            // html.ScrollTop = Scrollfortschritt in px von oben aus

            // IF Top of object is visible(0%) + X px = 100%
            const maxScrollTop = html.scrollHeight - window.innerHeight;
            // const scrollFraction = scrollTop / maxScrollTop;


            var welcomeheaderheight = $('.entry-header').offset().top + $('.entry-header').outerHeight(true);
            var appsheight = $('#tapped-apps').offset().top + $('#tapped-apps').outerHeight(true);
			var animationphonesheight = $('.animationphones').outerHeight(true) - 180;
			
			
			var distance = -(scrollTop - welcomeheaderheight - animationphonesheight);
			var numberOfFrames = 51;
			var m = 8;

            const scrollFraction = scrollTop / (welcomeheaderheight + animationphonesheight + (appsheight / 3.5));


            var appsheight = $('#tapped-apps').offset().top + $('#tapped-apps').outerHeight(true);
			
			var frameIndex = 0;
			if (distance > 0 && distance < (numberOfFrames * m) ) {

				frameIndex = 50 - Math.round( distance / m);

			   
				
			} else if ( distance > numberOfFrames * m ) {
				frameIndex = 1;
			} else {
				frameIndex = 51;
			}
			
			if (frameIndex == 0) {
				frameIndex = 1;
			}

			requestAnimationFrame(() => updateImage(frameIndex ));
			
			
			
			//}

    });
});




preloadImages();
});