from django.shortcuts import get_object_or_404, render, redirect
from django.http import JsonResponse

from django.template import Context
from django.template.loader import render_to_string, get_template
from django.core.mail import EmailMessage

from django.contrib.auth.models import User
from django.conf import settings
from .forms import DeliveryAdressForm, OrderForm
from .models import articles, articleprices, addresses, countries, orders
from accounts.models import CustomerData
from landingpages.models import Page
from django.views.decorators.csrf import csrf_exempt
from paypalcheckoutsdk.core import PayPalHttpClient, SandboxEnvironment, LiveEnvironment
from paypalcheckoutsdk.orders import OrdersCaptureRequest, OrdersPatchRequest
from paypalcheckoutsdk.payments import AuthorizationsCaptureRequest
from paypalhttp import HttpError
import stripe
from django.http import HttpResponse
import re
import json

#Stripe
stripe.api_key = settings.STRIPE_PRIVATEKEY

#PayPal
client_id = settings.PAYPAL_CLIENT
client_secret = settings.PAYPAL_SECRET
# Creating a PayPal environment
environment = LiveEnvironment(client_id=client_id, client_secret=client_secret)
client = PayPalHttpClient(environment)

def index(request):
    return redirect('/')

def list_products(request):
    if request.user.is_authenticated:
        product = articles.objects.all()
        return render(request, 'shop/articles.html', {'product': product})
    else:
        return redirect('/')

def product_detail(request, productid):
    if request.user.is_authenticated:

        #set session for productamount and id for checkout
        #TODO validate
        if request.method == 'POST':
            request.session['articleid'] = productid
            request.session['articleamount'] = request.POST['articleamount']
            data = {
                'status': 'success'
            }
            return JsonResponse(data)

        #render product detail html template
        product = get_object_or_404(articles, pk=productid)
        prices = articleprices.objects.filter(article_id=productid).order_by('sort')
        return render(request, 'shop/article_detail.html', {
            'product': product,
            'prices': prices,
        })
    else:
        return redirect('/')

def delivery(request):
    if request.user.is_authenticated:
        try:
            deliveryinfo = get_object_or_404(addresses, pk=request.user.id)
            form_address = DeliveryAdressForm(instance=deliveryinfo)
        except:
            form_address = DeliveryAdressForm()
        if request.method == 'POST':
            form_address = DeliveryAdressForm(request.POST)
            try:
                if form_address.is_valid():
                    address = form_address.save(commit=False)
                    address.user_id = request.user.id
                    address.save()
                    data = {
                        'status': 'success'
                    }
                    return JsonResponse(data)
                else:
                    data = {
                        'status': 'error',
                        'error': 'form is not valid'
                    }
                    return JsonResponse(data)
            except:
                data = {
                    'status': 'error',
                    'error': 'unexpected error'
                }
                return JsonResponse(data)

        return render(request, 'shop/delivery.html', {
            'form_address': form_address,
        })
    else:
        return redirect('/')

@csrf_exempt
def paymentsapi(request):
    body_unicode = request.body.decode('utf-8')
    data = json.loads(body_unicode)
    intent = None

    try:
        if 'paymentmethod' in data:
            if data['paymentmethod'] == 'iban':
                article = data['articleid']
                amount = data['articleamount']
                request.session["sourceid"] = data['sourceid']
                request.session["paymentmethod"] = 'iban'

                # Get price
                product = get_object_or_404(articleprices, article_id=article, quantity=amount)
                productprice = str(product.price)
                request.session["amountstripe"] = productprice.replace('.', '')

                request.session["articleid"] = article
                request.session["articleamount"] = amount
                request.session["transactionid"] = data['sourceid']
                request.session["totalcosts"] = productprice
                request.session.modified = True

                return JsonResponse({'requires_confirmation': True}, status=200)

            if data['paymentmethod'] == 'creditcard':
                if 'payment_method_id' in data:

                    article = data['articleid']
                    amount = data['articleamount']

                    # Get price
                    product = get_object_or_404(articleprices, article_id=article, quantity=amount)
                    productprice = str(product.price)
                    amountstripe = productprice.replace('.', '')

                    # Check if Stripe Customer exists, if not create
                    customer = request.user
                    address = addresses.objects.get(pk=customer.id)
                    customerdata = CustomerData.objects.get(pk=customer.id)

                    if address.bill_name == '':
                        fullname = address.delivery_name
                    else:
                        fullname = address.bill_name

                    if customerdata.stripe_customerid == '':
                        customer = stripe.Customer.create(
                            email=customer.email,
                            name=fullname,
                            description="Tapped.to Customer",
                        )
                        stripecustomerid = customer['id']
                        customerdata.stripe_customerid = customer['id']
                        customerdata.save()
                    else:
                        stripecustomerid = customerdata.stripe_customerid


                    intent = stripe.PaymentIntent.create(
                        payment_method = data['payment_method_id'],
                        amount = amountstripe,
                        currency = 'eur',
                        confirmation_method = 'manual',
                        confirm = False,
                        customer = stripecustomerid,
                    )

                    # Create tmp session data for checkout
                    request.session["articleid"] = article
                    request.session["articleamount"] = amount
                    request.session["transactionid"] = intent.id
                    request.session["totalcosts"] = productprice
                    request.session["paymentmethod"] = 'creditcard'

                    #save intent id for later confirmation
                    request.session['payment_intent_id'] = intent.id

                    #save client secret for action_required
                    request.session['client_secret'] = intent.client_secret
                    request.session.modified = True


                elif 'payment_intent_id' in data:
                    return JsonResponse({'requires_confirmation': True, 'payment_intent_client_secret': intent.client_secret}, status=200)


    except stripe.error.CardError as e:
        # Display error on client
        return json.dumps({'error': e.user_message}), 200
    return generate_response(intent)

def generate_response(intent):
    # Note that if your API version is before 2019-02-11, 'requires_action'
    # appears as 'requires_source_action'.
    if intent.status == 'requires_action' and intent.next_action.type == 'use_stripe_sdk':
        # Tell the client to handle the action
        return JsonResponse({'requires_action': True, 'payment_intent_client_secret': intent.client_secret}, status=200)

    elif intent.status == 'requires_confirmation':
        #if intent.status == 'requires_confirmation' and intent.next_action.type == 'use_stripe_sdk':
            # Tell the client to handle the action
            return JsonResponse({'requires_confirmation': True, 'payment_intent_client_secret': intent.client_secret}, status=200)
    elif intent.status == 'succeeded':
        # The payment didn’t need any additional actions and completed!
        # Handle post-payment fulfillment
        return JsonResponse({'success':True}, status=200)
    else:
        # Invalid status
        return JsonResponse({'error':'Invalid PaymentIntent status'}, status=500)

def payments(request):
    if request.user.is_authenticated:
        articleid = request.session["articleid"]
        articleamount = request.session["articleamount"]
        product = get_object_or_404(articleprices, article_id=articleid, quantity=articleamount)
        request.session["totalcosts"] = str(product.price)
        price = str(product.price)
        stripeprice = price.replace('.', '')

        request.session["paymentmethod"] = 'paypal'
        orderform = OrderForm()
        return render(request, 'shop/payments.html', {
            'orderform': orderform,
            'totalprice': product.price,
            'stripeprice': stripeprice,
        })
    else:
        return redirect('/')

def paypalhandler(request):
    if request.method == 'POST':
        request.session['authorizationid'] = request.POST['authorizationid']
        request.session['payment_intent_id'] = request.POST['orderid']
        request.session.modified = True
        return JsonResponse({'payment_handler_success': True}, status=200)

def checkoutapi(request):
    if request.user.is_authenticated:
        # Get tmp session data for checkout
        articleid = request.session["articleid"]
        articleamount = request.session["articleamount"]
        totalcosts = request.session["totalcosts"]

        if request.method == 'POST' and 'confirmpurchase' in request.POST:

            if request.session["paymentmethod"] == 'iban':
                customer = request.user
                address = addresses.objects.get(pk=customer.id)
                customerdata = CustomerData.objects.get(pk=customer.id)

                if address.bill_name == '':
                    fullname = address.delivery_name
                else:
                    fullname = address.bill_name

                if customerdata.stripe_customerid == '':
                    customer = stripe.Customer.create(
                        email=customer.email,
                        name= fullname,
                        source=request.session["sourceid"],
                        description="Tapped.to Customer",
                    )
                    stripecustomerid = customer['id']
                    customerdata.stripe_customerid = customer['id']
                    customerdata.save()
                else:
                    stripecustomerid = customerdata.stripe_customerid

                charge = stripe.Charge.create(
                    amount=request.session["amountstripe"],
                    currency='eur',
                    customer=stripecustomerid,
                    source=request.session["sourceid"],
                )
                transactionid = charge['id']

            if request.session["paymentmethod"] == 'creditcard':
                transactionid = request.session['payment_intent_id']
                try:
                    stripe.PaymentIntent.confirm(request.session['payment_intent_id'])
                except stripe.error.CardError as e:

                    regex = r".*: "
                    test_str = str(e)
                    subst = "Sorry, there was an error: "
                    response = re.sub(regex, subst, test_str, 0, re.MULTILINE)

                    return JsonResponse({'error': {'message': response}}, status=400)

                #check if additional actions are required (3ds secure) and then confirm the payment again
                if stripe.PaymentIntent.retrieve(request.session['payment_intent_id']).status == 'requires_action':
                    return JsonResponse({'requires_action': True, 'payment_intent_client_secret': request.session['client_secret']}, status=200)

            if request.session["paymentmethod"] == 'applepay':
                transactionid = request.session['payment_intent_id']
                try:
                    stripe.PaymentIntent.confirm(request.session['payment_intent_id'])
                except stripe.error.CardError as e:

                    regex = r".*: "
                    test_str = str(e)
                    subst = "Sorry, there was an error: "
                    response = re.sub(regex, subst, test_str, 0, re.MULTILINE)

                    return JsonResponse({'error': {'message': response}}, status=400)

                #check if additional actions are required (3ds secure) and then confirm the payment again
                if stripe.PaymentIntent.retrieve(request.session['payment_intent_id']).status == 'requires_action':
                    return JsonResponse({'requires_action': True, 'payment_intent_client_secret': request.session['client_secret']}, status=200)


            if request.session["paymentmethod"] == 'paypal':
                requestpaypal = AuthorizationsCaptureRequest(request.session['authorizationid'])
                response = client.execute(requestpaypal)
                transactionid = request.session['payment_intent_id']

            customernote = request.POST["note"]

            # Get tmp session data for checkout
            articleid = request.session["articleid"]
            articleamount = request.session["articleamount"]
            totalcosts = request.session["totalcosts"]

            # Save order into db
            pageobject = get_object_or_404(Page, user_id=request.user.id)
            order = orders(user_id=request.user.id, page_id=pageobject.pageid, amount=articleamount,
                           total_costs=totalcosts, note=customernote, transactioncode=transactionid,
                           article_id=articleid)
            order.save()

            # Update Stock
            product = articles.objects.get(pk=articleid)
            productstock = int(product.in_stock)
            orderamount = int(articleamount)
            product.in_stock = (productstock - orderamount)
            product.save()

            # Get article information
            article = articles.objects.get(pk=articleid)
            user = User.objects.get(id=order.user_id)

            # Send e-Mail to customer
            context = {
                'article': article,
                'articleamount': articleamount,
                'totalcosts': totalcosts
            }
            message = render_to_string('mailing/order/confirmation.html', context)
            msg = EmailMessage(
                settings.ORDER_SUBJECT + str(order.id),
                message,
                settings.ORDER_NAME + "<" + settings.ORDER_EMAIL + ">",
                [user.email],
            )
            msg.content_subtype = "html"  # Main content is now text/html
            msg.send()

            # Send e-mail to Tapped
            context = {
                'article': article,
                'articleamount': articleamount,
                'totalcosts': totalcosts
            }
            message = render_to_string('mailing/order/tapped_confirmation.html', context)
            msg = EmailMessage(
                'Neue Bestellung #'+ str(order.id),
                message,
                settings.ORDER_NAME + "<" + settings.ORDER_EMAIL + ">",
                [settings.ORDER_INTERN_EMAIL],
            )
            msg.content_subtype = "html"  # Main content is now text/html
            msg.send()

            # Delete tmp session data
            del request.session["articleid"]
            del request.session["articleamount"]
            del request.session["totalcosts"]
            del request.session["paymentmethod"]

            if 'payment_intent_id' in request.session:
                del request.session['payment_intent_id']
            if 'sourceid' in request.session:
                del request.session["sourceid"]
            if 'transactionid' in request.session:
                del request.session["transactionid"]
            if 'client_secret' in request.session:
                del request.session["client_secret"]
            if 'amountstripe' in request.session:
                del request.session["amountstripe"]
            if 'authorizationid' in request.session:
                del request.session["authorizationid"]

            return JsonResponse({'success':True}, status=200)

        #render checkout html
        productid = request.session["articleid"]
        product = get_object_or_404(articles, pk=productid)

        orderform = OrderForm()
        return render(request, 'shop/checkout.html', {
            'product': product,
            'orderform': orderform,
            'articleid': articleid,
            'articleamount': articleamount,
            'totalcosts': totalcosts,
        })
    else:
        return redirect('/')

def success(request):
    if request.user.is_authenticated:
        return render(request, 'shop/success.html')
    else:
        return redirect('/')

# Paymenttypes
def creditcard(request):
    return render(request, 'shop/paymenttypes/creditcard.html')
