from django.urls import path

from . import views
from accounts import views as account_views

app_name = 'shop'
urlpatterns = [
    path('', views.index, name='index'),
    path('products/', views.list_products, name='list_products'),
    path('product/<int:productid>/', views.product_detail, name='product_detail'),
    path('delivery/', views.delivery, name='delivery'),
    path('payments/', views.payments, name='payment'),

    path('paymentsapi/', views.paymentsapi, name='paymentsapi'),
    path('checkoutapi/', views.checkoutapi, name='checkoutapi'),

    #Paymenttypes
    path('payment/creditcard/', views.creditcard, name='creditcard'),
    path('payment/paypal/', views.paypalhandler, name='paypalhandler'),

    path('success/', views.success, name='success'),
]