from django.db import models
from accounts.models import CustomerData
from landingpages.models import Page
import datetime

class articles(models.Model):
    name = models.CharField(max_length=200)
    description = models.CharField(max_length=400)
    shortdescription = models.CharField(max_length=400)
    picture = models.CharField(max_length=200)
    price = models.DecimalField(max_digits=6, decimal_places=2)
    in_stock = models.IntegerField()

class articleprices(models.Model):
    article = models.ForeignKey(articles, on_delete=models.CASCADE, parent_link=True)
    quantity = models.IntegerField(null=True)
    price = models.DecimalField(max_digits=6, decimal_places=2)
    customtext = models.CharField(max_length=200)
    sort = models.IntegerField(null=True)

class countries(models.Model):
    countrycode = models.CharField(max_length=3, primary_key=True)
    name = models.CharField(max_length=50)
    prefix_placeholder = models.CharField(max_length=6)
    prefix = models.CharField(max_length=4)
    shipping_costs = models.DecimalField(max_digits=6, decimal_places=2)

    def __str__(self):
        return self.name

    def __repr__(self):
        return str(self.name)


class addresses(models.Model):
    user = models.OneToOneField(CustomerData, primary_key=True, on_delete=models.CASCADE, parent_link=True)
    bill_company = models.CharField(max_length=200, blank=True)
    bill_name = models.CharField(max_length=200, blank=True)
    bill_street = models.CharField(max_length=200, blank=True)
    bill_city = models.CharField(max_length=100, blank=True)
    bill_zip = models.CharField(max_length=8, blank=True)
    bill_country = models.ForeignKey(countries, on_delete=models.CASCADE, related_name='bill_addresses', blank=True)
    delivery_company = models.CharField(max_length=200, blank=True)
    delivery_name = models.CharField(max_length=200)
    delivery_street = models.CharField(max_length=200)
    delivery_city = models.CharField(max_length=100)
    delivery_zip = models.CharField(max_length=8)
    delivery_country = models.ForeignKey(countries, on_delete=models.CASCADE, related_name='delivery_addresses')

    def getBillCountryName(self):
        return self.bill_country.name

    def getDeliveryCountryName(self):
        return self.delivery_country.name

class voucher(models.Model):
    code = models.CharField(max_length=200, primary_key=True)
    amount = models.IntegerField(null=True)
    percent = models.IntegerField(null=True)
    minimum_amount = models.DecimalField(max_digits=6, decimal_places=2, blank=True)
    valid_from = models.DateField(default=datetime.date.today, blank=True)
    valid_until = models.DateField(default=datetime.date.today, blank=True)
    uses = models.IntegerField(null=True)

class orders(models.Model):
    user = models.ForeignKey(CustomerData, on_delete=models.CASCADE, parent_link=True)
    orderdate = models.DateTimeField(auto_now=True)
    page = models.ForeignKey(Page, on_delete=models.CASCADE, parent_link=True)
    article = models.ForeignKey(articles, on_delete=models.CASCADE)
    amount = models.IntegerField()
    total_costs = models.DecimalField(max_digits=6, decimal_places=2)
    note = models.TextField(max_length=500)
    status = models.IntegerField(default=1)
    transactioncode = models.CharField(max_length=50, blank=False)
    voucher = models.ForeignKey(voucher, on_delete=models.CASCADE, null=True)