# Generated by Django 3.1.1 on 2020-10-27 12:46

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='articles',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200)),
                ('description', models.CharField(max_length=400)),
                ('shortdescription', models.CharField(max_length=400)),
                ('picture', models.CharField(max_length=200)),
                ('price', models.DecimalField(decimal_places=2, max_digits=6)),
                ('in_stock', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='countries',
            fields=[
                ('countrycode', models.CharField(max_length=3, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=50)),
                ('prefix_placeholder', models.CharField(max_length=6)),
                ('prefix', models.CharField(max_length=4)),
                ('shipping_costs', models.DecimalField(decimal_places=2, max_digits=6)),
            ],
        ),
        migrations.CreateModel(
            name='voucher',
            fields=[
                ('code', models.CharField(max_length=200, primary_key=True, serialize=False)),
                ('amount', models.IntegerField(null=True)),
                ('percent', models.IntegerField(null=True)),
                ('minimum_amount', models.DecimalField(blank=True, decimal_places=2, max_digits=6)),
                ('valid_from', models.DateField(blank=True, default=datetime.date.today)),
                ('valid_until', models.DateField(blank=True, default=datetime.date.today)),
                ('uses', models.IntegerField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='orders',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, parent_link=True, to='accounts.customerdata')),
                ('orderdate', models.DateTimeField(auto_now=True)),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, parent_link=True, to='landingpages.page')),
                ('amount', models.IntegerField()),
                ('total_costs', models.DecimalField(decimal_places=2, max_digits=6)),
                ('note', models.TextField(max_length=500)),
                ('status', models.IntegerField(default=1)),
                ('transactioncode', models.CharField(max_length=50)),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='shop.articles')),
                ('voucher', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='shop.voucher')),
            ],
        ),
    ]
