from django import forms
from django.forms import ModelForm
from .models import addresses, countries, orders, articles

class DeliveryAdressForm(ModelForm):
    #bill_country = forms.ChoiceField(choices=[(c.countrycode, c.name) for c in countries.objects.all()], initial='DE')
    #delivery_country = forms.ChoiceField(choices=[(c.countrycode, c.name) for c in countries.objects.all()], initial='DE')
    bill_country = forms.ModelChoiceField(queryset=countries.objects.all(), empty_label=None)
    delivery_country = forms.ModelChoiceField(queryset=countries.objects.all(), empty_label=None)
    class Meta:
        model = addresses
        fields = ['bill_company', 'bill_name', 'bill_street', 'bill_city', 'bill_zip', 'bill_country', 'delivery_company', 'delivery_name', 'delivery_street', 'delivery_city', 'delivery_zip', 'delivery_country']
        widgets = {
            'bill_country': forms.Select(attrs={'class': 'select'}),
            'delivery_country': forms.Select(attrs={'class': 'select'}),
        }

class OrderForm(ModelForm):
    class Meta:
        model = orders
        fields = ['amount', 'note', 'article']