from django.shortcuts import get_object_or_404, render, redirect
from django.http import HttpResponse

from .models import Page, Consumer

def index(request):
    return redirect('/')

def lp(request, pageid):
    page = get_object_or_404(Page, pk=pageid)
    consumer = get_object_or_404(Consumer, pk=pageid)
    context = {
    "page": page,
    "consumer": consumer,
    }
    page.increment_views()

    return render(request, 'landingpages/consumer.html', context)
