from django.shortcuts import render
from django.http import HttpResponse, HttpResponseRedirect
import datetime

def imprint(request):
    return render(request, 'frontend/imprint.html')

def privacy(request):
    return render(request, 'frontend/privacy.html')

def badrequest(request, exception=None):
    return render(request, 'frontend/400.html')

def permissions(request, exception=None):
    return render(request, 'frontend/403.html')

def notfound(request, exception=None):
    return render(request, 'frontend/404.html')

def error(request, exception=None):
    return render(request, 'frontend/500.html')

def afflinatecookie(request, affid):
    print(affid)
    expiredate = datetime.datetime.now() + datetime.timedelta(days=730)
    expiredate = datetime.datetime.replace(expiredate, hour=0, minute=0, second=0)
    expires = datetime.datetime.strftime(expiredate, "%a, %d-%b-%Y %H:%M:%S GMT")
    response = HttpResponseRedirect('/')
    response.set_cookie('affiliate', affid, expires = expires)
    return response