from django.shortcuts import get_object_or_404, render, redirect
from django.urls import reverse
from django.http import HttpResponse, HttpResponseRedirect
from django.contrib import messages
from django.views.generic import DetailView
from django.contrib.auth.models import User
from django.contrib.auth.decorators import login_required
from landingpages.models import Page, Links, PersonalInfo, LinkType, vcards, Pageredirects
from shop.models import orders, addresses
from accounts.models import CustomerData
from accounts.forms import PhoneCountrysPage
from advertising.models import ads
from django.http import JsonResponse
from django.core.files.storage import FileSystemStorage
from wsgiref.util import FileWrapper
from django.http import FileResponse
from django.conf import settings

from django.template import Context
from django.template.loader import render_to_string, get_template
from django.core.mail import EmailMessage



from io import StringIO
import json

from django.forms import modelformset_factory

from .forms import NewPageMeta, LinkForm, LinkTypeForm, PersonalInfoForm, ThemeForm, vCardForm, AddChipForm
import uuid
import magic
from uuid import UUID

from tapped.settings import MAX_UPLOAD_SIZE, MAX_UPLOAD_NAME, AVATAR_FILETYPES


def index(request):
    if request.user.is_authenticated:
        if request.user.data.phone_verified == True:
            user = request.user
            page = get_object_or_404(Page, user_id=user.id)
            return redirect(reverse('backend:pages', kwargs={'pageid': page.pageid}))
        else:
            return redirect('/verification/')
    else:
        return redirect(reverse('login'))


def adindex(request, adindex, pageid):
    return pages(request, pageid, adindex)

def newpages(request, pageid):
    return pages(request, pageid)

def pages(request, pageid, adindex=None):
    # Check if site with this pageid exists
    try:
        page = Page.objects.get(pk=pageid)

        # Check if this page has an ad
        if page.advertising_id != None:
            # Check if the ad in the url is the ad in the page settings
            if adindex != page.advertising_id:
                adidex = page.advertising_id
                # Redirect to the right ad page
                if page.pagename != "":
                    return redirect('/' + page.advertising_id + '/' + page.pagename)
                else:
                    return redirect('/' + page.advertising_id + '/' + str(page.pageid))

        # Check if page has an ad and url is without ad
        if page.advertising_id != None and adindex == None:
            if page.pagename != "":
                return redirect('/' + page.advertising_id + '/' + page.pagename)
            else:
                return redirect('/' + page.advertising_id + '/' + str(page.pageid))
    except:
        # Check if pageid is a public url
        try:
            page = Page.objects.get(pagename=pageid)
            pageid = page.pageid
            # Check if this public url is a page with ads
            if page.advertising_id != None and adindex == None:
                return redirect('/'+ page.advertising_id + '/' + page.pagename)
            # Check if adindex is in url but page has no ads
            if page.advertising_id == None and adindex != None:
                return redirect('/pages/' + page.pagename)
        except:
            #Check if pageid is a redirected url
            try:
                redirectpage = Pageredirects.objects.get(pk=pageid)
                pageid = redirectpage.page_id
                page = Page.objects.get(pk=pageid)

                # Check if this UUID has a public url
                if page.pagename != "":
                    return redirect('/pages/' + page.pagename)
                else:
                    return redirect('/pages/' + str(pageid))
            except:
                # Check if UUID is valid
                try:
                    uuid_obj = UUID(pageid, version=4)
                    response = HttpResponseRedirect('/registerchip')
                    response.set_cookie('registersite', pageid)

                    response.set_cookie('adindex', adindex)
                    request.session['registersiteuuid'] = pageid
                    return response
                except:
                    return redirect('/')


    personalinfo = get_object_or_404(PersonalInfo, pk=pageid)
    LinkList = Links.objects.filter(page_id=pageid).order_by('sort')
    placeholders = LinkType.objects.all()
    LinkFormSet = modelformset_factory(Links, extra=0, form=LinkForm)
    formset = LinkFormSet(queryset=Links.objects.filter(page_id=pageid, value__exact=''))
    personalinfoform = PersonalInfoForm(instance=personalinfo)
    linktype = LinkTypeForm()
    theme = ThemeForm(request.user, initial={'theme': personalinfo.theme})
    addnewlink = LinkForm()
    vcardform = vCardForm()
    addchipform = AddChipForm()
    form_countrys = PhoneCountrysPage()

    hostname = settings.HOSTNAME

    if adindex is not None:
        try:
            adinfo = get_object_or_404(ads, pk=adindex)
            adlinktext = adinfo.name
            adlink = adinfo.link
            adclass = adinfo.css
            ad = True
        except:
            return redirect(reverse('backend:pages', kwargs={'pageid': page.pageid}))
    else:
        ad = False

    if page.user_id == request.user.id:
        if request.method == 'POST':
            if "typeform" in request.POST:
                linktypeform = LinkTypeForm(request.POST)
                if linktypeform.is_valid():
                    linktype = linktypeform.cleaned_data.get("type")
                    Links.objects.create(type_id=linktype, page_id=page.pageid)

            elif "linkform" in request.POST:
                formset = LinkFormSet(request.POST, queryset=Links.objects.filter(page_id=pageid))
                if formset.is_valid():
                    formset.save(commit=False)
                    formset.page_id = pageid
                    formset.save()

            elif "personalinfo" in request.POST:
                personalform = PersonalInfoForm(request.POST, request.FILES, instance=personalinfo)
                if personalform.is_valid():
                    personalform.save(commit=False)
                    file = personalform.cleaned_data.get("avatar", False)
                    themeid = request.POST.get("theme")
                    if bool(request.FILES.get('avatar', False)) == True:
                        filetype = magic.from_buffer(file.read()).upper().split(" ")[0]
                        if filetype in AVATAR_FILETYPES:
                            if file.size > int(MAX_UPLOAD_SIZE):
                                messages.error(request, 'File too large. Maximum filesize is %s' % MAX_UPLOAD_NAME)
                            else:
                                personalform.save()
                        else:
                            messages.error(request, 'Filetype not supported.')
                    else:
                        personalform.save()

            elif "addnewchip" in request.POST:
                addnewchip = AddChipForm(request.POST)
                if addnewchip.is_valid():
                    customname = addnewchip.cleaned_data["customname"]
                    redirectname = request.session['registersiteuuid']
                    try:
                        uuid_obj = UUID(request.session['registersiteuuid'], version=4)
                        Pageredirects.objects.create(user_id=page.user_id, redirectname=redirectname, page_id=pageid,
                                                     customname=customname)
                        messages.success(request, 'NFC Chip successfully linked to your profile.')
                    except:
                        messages.error(request, 'NFC Chip successfully linked to your profile.')


            elif "addnewlink" in request.POST:
                addnewlink = LinkForm(request.POST)
                if addnewlink.is_valid():
                    objecttype = request.POST.get("objecttype")
                    value = addnewlink.cleaned_data["value"]
                    title = addnewlink.cleaned_data["title"]

                    if request.POST.get("spotifyartistid"):
                        value = request.POST.get("spotifyartistid")

                    Links.objects.create(type_id=objecttype, page_id=page.pageid, value=value, title=title)

            elif "addnewvcard" in request.POST:
                addnewlink = LinkForm(request.POST)
                vcardform = vCardForm(request.POST)
                if addnewlink.is_valid() and vcardform.is_valid():
                    vcard = vcardform.save()
                    objecttype = request.POST.get("objecttype")
                    value = "vcard"
                    title = addnewlink.cleaned_data["title"]

                    Links.objects.create(type_id=objecttype, page_id=page.pageid, value=value, title=title, external_widget_id=vcard.id)

            elif "remove" in request.POST:
                objectid = request.POST.get("removelink")
                Links.objects.filter(page_id=pageid, id=objectid).delete()

            return HttpResponseRedirect('/pages/')

        context = {
            'ad': ad,
            'linkform': formset,
            'linktype': linktype,
            'personalinfo': personalinfo,
            'LinkList': LinkList,
            'requestuser': request.user.id,
            'pageowner': page.user_id,
            'personalinfoform': personalinfoform,
            'page': page,
            'addnewlink': addnewlink,
            'placeholders': placeholders,
            'theme': theme,
            'vcardform': vcardform,
            'addchipform': addchipform,
            'hostname': hostname,
            'form_countrys': form_countrys,
        }

        if adindex is not None:
            context.update(
                {
                    'adlinktext': adlinktext,
                    'adlink': adlink,
                    'adclass': adclass,
                }
            )
        response = render(request, 'backend/page.html', context)
        response.set_cookie(key="ownpageid", value=pageid)
        return response

    else:
        cookiepageid = None
        cookiepageid = request.COOKIES.get('ownpageid')
        if not pageid == cookiepageid:
            page.increment_views()


        context = {
            'ad': ad,
            'linkform': formset,
            'linktype': linktype,
            'personalinfo': personalinfo,
            'LinkList': LinkList,
            'requestuser': request.user.id,
            'pageowner': page.user_id,
            'personalinfoform': personalinfoform,
            'page': page,
            'addnewlink': addnewlink,
            'placeholders': placeholders,
            'theme': theme,
            'form_countrys': form_countrys,
        }


        if adindex is not None:
            context.update({
            'adlinktext': adlinktext,
            'adlink': adlink,
            'adclass': adclass,
            })

        return render(request, 'backend/page.html', context)

def sortView(request, pageid, adindex):
    try:
        page = get_object_or_404(Page, page=pageid)
    except:
        page = get_object_or_404(Page, pagename=pageid)
    if page.user_id == request.user.id:
        if request.method == 'POST':
            objects = json.loads(request.POST.get('data', ''))

            for k in objects:
                objectid = k["linkid"]
                sortvalue = k["sortvalue"]

                object = Links.objects.get(pk=objectid)
                object.sort = sortvalue
                object.save()
            response = HttpResponse('ok')
            return response

def deleteView(request, pageid, adindex, objectid):
    try:
        page = get_object_or_404(Page, page=pageid)
    except:
        page = get_object_or_404(Page, pagename=pageid)
        pageid = page.pageid
    if page.user_id == request.user.id:
        if request.method == 'POST':
            linkobject = Links.objects.get(page_id=pageid, id=objectid)
            if linkobject.type_id == 22:
                vcards.objects.get(id=linkobject.external_widget_id).delete()
            linkobject.delete()
    return HttpResponse('')

def vcardResponse(response, pageid, externwidgetid):
    try:
        validvcard = Links.objects.get(external_widget_id=externwidgetid)
        if pageid != str(validvcard.page_id):
            return HttpResponseRedirect('/pages/' + pageid)
        else:
            ''
    except:
        return HttpResponseRedirect('/pages/' + pageid)
    vcardinfo = get_object_or_404(vcards, id=externwidgetid)

    lastname = vcardinfo.last_name
    firstname = vcardinfo.first_name
    title = vcardinfo.vcard_title
    displayname = vcardinfo.display_name
    companyname = vcardinfo.companyname
    job = vcardinfo.job
    position = vcardinfo.position
    company_website = vcardinfo.company_website
    private_website = vcardinfo.private_website
    email = vcardinfo.email
    company_phone = vcardinfo.company_phonenumber
    company_mobilenumber = vcardinfo.company_mobilenumber
    company_street = vcardinfo.company_street
    company_plz = vcardinfo.company_plz
    company_city = vcardinfo.company_city
    company_country = vcardinfo.company_country
    private_street = vcardinfo.private_street
    private_phonenumber = vcardinfo.private_phonenumber
    private_plz = vcardinfo.private_plz
    private_city = vcardinfo.private_city
    private_country =vcardinfo.private_country

    vcard = StringIO('BEGIN:VCARD\n'\
        'VERSION:3.0\n'\
        'N:{};{}\n'\
        'FN:{} {}\n'\
        'TITLE:{}\n'\
        'ORG:{}\n'\
        'URL;type=WORK:{}\n'\
        'URL;type=PRIVATE:{}\n'\
        'EMAIL;type=WORK;type=PREF:{}\n'\
        'TEL;type=WORK;type=VOICE:{}\n'\
        'TEL;type=WORK;type=CELL:{}\n'\
        'TEL;TYPE=HOME,VOICE:{}\n'\
        'ADR;type=WORK;type=pref:;;{};{};;{};{}\n'\
        'ADR;type=HOME;type=pref:;;{};{};;{};{}\n'\
        'END:VCARD'.format(
            lastname,
            firstname,
            firstname,
            lastname,
            title,
            companyname,
            company_website,
            private_website,
            email,
            company_phone,
            private_phonenumber,
            company_mobilenumber,
            company_street,
            company_city,
            company_plz,
            company_country,
            private_street,
            private_city,
            private_plz,
            private_country,
        )
    )

    response = HttpResponse(FileWrapper(vcard), content_type='text/x-vcard')
    response['Content-Disposition'] = 'attachment; filename=vcard.vcf'
    return response

def deleteUser(request, searchid):
    if request.user.is_staff & settings.DEBUG == True:
        searchid = str(searchid)
        try:
            page = get_object_or_404(Page, page=searchid)
            userid = page.user_id
            print(page.pageid)
            # Delete Widgets
            # Check if type_id == 22
            try:
                externalwidgets = Links.objects.all().filter(page_id=page.pageid, type_id=22)
                for entry in externalwidgets:
                    vcards.objects.filter(id=entry.external_widget_id).delete()
                Links.objects.all().filter(page_id=page.pageid, type_id=22).delete()
            except:
                print("no external widgets found")
            try:
                Links.objects.all().filter(page_id=page.pageid).delete()
            except Links.DoesNotExist:
                print("no widgets found")

            # Check if pageredirect exists -> delete it
            try:
                Pageredirects.objects.all().filter(page_id=page.pageid).delete()
            except Pageredirects.DoesNotExist:
                print("no redirects found")

            # Delete PersonalInfo
            try:
                get_object_or_404(PersonalInfo, pk=page.pageid).delete()
            except PersonalInfo.DoesNotExist:
                print("No Personalinfo found")

            # Delete Shop Orders
            try:
                orders.objects.all().filter(page_id=page.pageid).delete()
            except:
                print("No Order found")

            # Delete Page
            try:
                get_object_or_404(Page, pk=page.pageid).delete()
            except Page.DoesNotExist:
                print("Page not found")
            # Delete themes_allowed_users
            try:
                user = get_object_or_404(User, pk=userid)
                user.allowed_themes.through.objects.all().delete()
            except User.DoesNotExist:
                print("User doesnt exist")

            # Delete address
            try:
                get_object_or_404(addresses, pk=userid).delete()
            except Exception as e:
                print(e)

            # Delete CustomerData
            try:
                get_object_or_404(CustomerData, pk=userid).delete()
            except CustomerData.DoesNotExist:
                print("User doesnt exist")

            # Delete User
            try:
                get_object_or_404(User, pk=userid).delete()
            except User.DoesNotExist:
                print("User doesnt exist")

            return JsonResponse({'status': 'ok'}, status=200)


        # If ID == userID -> delete page + user
        except:
            try:
                user = get_object_or_404(User, id=searchid)
                page = get_object_or_404(Page, user_id=user.id)

                try:
                    externalwidgets = Links.objects.all().filter(page_id=page.pageid, type_id=22)
                    for entry in externalwidgets:
                        vcards.objects.filter(id=entry.external_widget_id).delete()
                    Links.objects.all().filter(page_id=page.pageid, type_id=22).delete()
                except:
                    print("no external widgets found")
                try:
                    Links.objects.all().filter(page_id=page.pageid).delete()
                except Links.DoesNotExist:
                    print("no widgets found")

                # Check if pageredirect exists -> delete it
                try:
                    Pageredirects.objects.all().filter(page_id=page.pageid).delete()
                except Pageredirects.DoesNotExist:
                    print("no redirects found")

                # Delete PersonalInfo
                try:
                    get_object_or_404(PersonalInfo, pk=page.pageid).delete()
                except PersonalInfo.DoesNotExist:
                    print("No Personalinfo found")

                # Delete Shop Orders
                try:
                    orders.objects.all().filter(page_id=page.pageid).delete()
                except:
                    print("No Order found")

                # Delete Page
                try:
                    get_object_or_404(Page, pk=page.pageid).delete()
                except Page.DoesNotExist:
                    print("Page not found")

                # Delete themes_allowed_users
                try:
                    user = get_object_or_404(User, pk=user.id)
                    user.allowed_themes.through.objects.all().delete()
                except User.DoesNotExist:
                    print("User doesnt exist")

                # Delete address
                try:
                    get_object_or_404(addresses, pk=user.id).delete()
                except Exception as e:
                    print(e)

                # Delete CustomerData
                try:
                    get_object_or_404(CustomerData, pk=user.id).delete()
                except CustomerData.DoesNotExist:
                    print("User doesnt exist")

                # Delete User
                try:
                    get_object_or_404(User, pk=user.id).delete()
                except User.DoesNotExist:
                    print("User doesnt exist")

                return JsonResponse({'status': 'ok'}, status=200)
            except:
                return JsonResponse({"status": "bad", "error": "can't find user or page"}, status=200)
    return JsonResponse({'status': 'bad', 'error': 'no permission or system is not in debug mode'}, status=200)