from django.urls import path

from . import views


app_name = 'backend'
urlpatterns = [
    path('', views.index, name='index'),
    path('<str:pageid>/', views.newpages, name='pages'),
    path('pages/<str:pageid>/', views.newpages, name='pages'),
    path('<str:adindex>/<str:pageid>/', views.adindex, name='pagesindex'),
    path('<str:pagename>/', views.newpages, name='pagesindex'),

    path('<str:pageid>/sort/', views.sortView, name='sortView'),
    path('<str:adindex>/<str:pageid>/sort/', views.sortView, name='sortView'),

    path('<str:pageid>/delete/<int:objectid>', views.deleteView, name='deleteView'),
    path('<str:adindex>/<str:pageid>/delete/<int:objectid>', views.deleteView, name='deleteView'),

    path('delete/<str:searchid>', views.deleteUser, name='deleteUser'),

    path('pages/<str:pageid>/<int:externwidgetid>/vcard', views.vcardResponse, name='vcardresponse'),
]