from django import forms
from django.contrib.auth.models import User
from django.forms import ModelForm
from django import forms
from landingpages.models import Page, Links, LinkType, PersonalInfo, Themes, vcards, Pageredirects


class NewPageMeta(ModelForm):
    class Meta:
        model = Page
        fields = ['pagename']

class AddChipForm(ModelForm):
    class Meta:
        model = Pageredirects
        fields = ['customname']

class LinkTypeForm(ModelForm):
    type = forms.ChoiceField(choices=[(c.id, c.classname) for c in LinkType.objects.all()], widget=forms.RadioSelect, initial='1')
    #type = forms.CharField()

    class Meta:
        model = LinkType
        ordering = ['id']
        fields = ['type']
        widgets = {
            'type': forms.RadioSelect(attrs={'class': 'select'}),
        }

class ThemeForm(ModelForm):
    theme = forms.ModelChoiceField(queryset=Themes.objects.none(), widget=forms.RadioSelect)

    class Meta:
        model = Themes
        ordering = ['id']
        fields = ['theme']
        widgets = {
            'theme': forms.RadioSelect(attrs={'class': 'select'}),
        }

    def __init__(self, user, *args, **kwargs):
        self.user = user
        super(ThemeForm, self).__init__(*args, **kwargs)
        all_themes = Themes.objects.all().values_list('id', flat=True)
        free_themes = Themes.objects.all().exclude(allowed_users__allowed_themes__in=all_themes)
        custom_themes = Themes.objects.filter(allowed_users__id=self.user.id)

        self.fields['theme'].queryset = free_themes | custom_themes

class LinkForm(ModelForm):
    class Meta:
        model = Links
        fields = ['value', 'title']

    def __init__(self, *args, **kwargs):
        super(LinkForm, self).__init__(*args, **kwargs)
        if self.instance.has_type():
            self.fields['value'].widget.attrs.update({'class': self.instance.type.classname})


class vCardForm(ModelForm):
    class Meta:
        model = vcards
        fields = ['vcard_title', 'first_name', 'last_name', 'display_name', 'private_website', 'private_phonenumber', 'private_street', 'private_city', 'private_plz', 'private_country', 'companyname', 'job', 'position', 'email', 'company_website', 'company_phonenumber', 'company_mobilenumber', 'company_street', 'company_city', 'company_plz', 'company_country']


class PersonalInfoForm(ModelForm):

    class Meta:
        model = PersonalInfo
        fields = ['name', 'atname', 'slogan', 'avatar', 'theme']
        THEME_CHOICES = ((c.id, c.classname) for c in Themes.objects.all())
        #THEME_CHOICES = [(c.id, c.getclass()) for c in Themes.objects.all()]
        widgets = {
            'theme': forms.RadioSelect(choices=THEME_CHOICES),
        }