from django.shortcuts import render, get_object_or_404
from django.http import JsonResponse
from django.conf import settings
from django.utils.http import urlencode
import urllib.request as ur
from landingpages.models import Page
import requests
import json


def get_json_response(response):
    if response.getcode() == 401:
        return {
                   'error': {
                        'message': 'The request requires user authentication or, if the request included authorization credentials, authorization has been refused for those credentials.',
                        'type': 'Unauthorized',
                        'code': 401
                    }
                }, 401
    if response.getcode() == 403:
        return {
                   'error': {
                        'message': 'The server understood the request, but is refusing to fulfill it.',
                        'type': 'Forbidden',
                        'code': 403
                    }
                }, 403
    if response.getcode() == 404:
        return {
                   'error': {
                        'message': 'The requested resource could not be found.',
                        'type': 'NotFound',
                        'code': 404
                    }
                }, 404
    if response.getcode() == 429:
        return {
                   'error': {
                        'message': 'Too many requests, please try again later.',
                        'type': 'RateLimit',
                        'code': 429
                    }
                }, 429
    if response.getcode() == 500:
        return {
                   'error': {
                        'message': 'Please report this error.',
                        'type': 'InternalServerError',
                        'code': 500
                    }
                }, 500
    if response.getcode() == 503:
        return {
                   'error': {
                        'message': 'The server is currently unable to handle the request due to a temporary condition which will be alleviated after some delay.',
                        'type': 'ServiceUnavailable',
                        'code': 503
                    }
                }, 503
    return json.load(response), None


def google_place_id(request, keywords):
    if request.user.is_authenticated:
        url = "%s?%s" %("https://maps.googleapis.com/maps/api/place/autocomplete/json", urlencode( {
            "input": keywords,
            "key": settings.GOOGLE_API,
        }))
        response = ur.urlopen(url)
        data = json.load(response)
        return JsonResponse(data)
    else:
        return JsonResponse(
            {'error': {
                'message': 'The request requires user authentication or, if the request included authorization credentials, authorization has been refused for those credentials.',
                'type': 'Unauthorized',
                'code': 401
            }}, status=401)

def get_spotify_token():
    AUTH_URL = 'https://accounts.spotify.com/api/token'
    auth_response = requests.post(AUTH_URL, {
        'grant_type': 'client_credentials',
        'client_id': settings.SPOTIFY_PUBLICKEY,
        'client_secret': settings.SPOTIFY_PRIVATEKEY,
    })

    auth_response_data = auth_response.json()
    access_token = auth_response_data['access_token']
    return access_token

def spotify_user(request, keywords):
    if request.user.is_authenticated:
        auth_token = get_spotify_token()

        url = "%s?%s" %("https://api.spotify.com/v1/search", urlencode( {
            "query": keywords,
        }))

        urlcodec = url + "{}{}{}{}"
        searchurl = urlcodec.format("&type=artist", "&offset=0", "&limit=10", "&access_token="+auth_token)

        response = ur.urlopen(searchurl)

        body, status = get_json_response(response)
        return JsonResponse(body, status=status)

    return JsonResponse(
        {'error': {
            'message': 'The request requires user authentication or, if the request included authorization credentials, authorization has been refused for those credentials.',
            'type': 'Unauthorized',
            'code': 401
        }}, status=401)

def spotify_redirect(request):
    if request.user.is_authenticated:
        page = get_object_or_404(Page, user_id=request.user.id)
        if page.pagename != "":
            pageid = page.pagename
        else:
            pageid = str(page.pageid)

        if page.advertising_id != None:
            pageid = page.advertising_id+"/"+pageid

        return render(request, 'api/spotify_redirect.html',
                  {'pageid': pageid, 'hostname': settings.HOSTNAME})
    else:
        return JsonResponse(
            {'error': {
                'message': 'The request requires user authentication or, if the request included authorization credentials, authorization has been refused for those credentials.',
                'type': 'Unauthorized',
                'code': 401
            }}, status=401)

def faq(request, keyword='None'):
    print(keyword)
    if keyword == "None":
        keyword == str("None")
    context = {
    "type": keyword,
    }
    return render(request, 'api/faq.html', context)


def phone_verification(phonenumber, verificationcode):
    phonemessage = settings.SMS_TEXT.format(verificationcode)
    if settings.SMS_TESTMODE == True:
        url = '{}?receiver={}&sender={}&msg={}&id={}&pw={}&time=0&msgtype=c&getID=1&test=1'.format(
            settings.SMS_API, phonenumber, settings.SMS_SENDER, phonemessage, settings.SMS_ID,
            settings.SMS_PRIVATEKEY)
    else:
        url = '{}?receiver={}&sender={}&msg={}&id={}&pw={}&time=0&msgtype=c&getID=1'.format(
            settings.SMS_API, phonenumber, settings.SMS_SENDER, phonemessage, settings.SMS_ID,
            settings.SMS_PRIVATEKEY)
    serialized_data = ur.urlopen(url).read()