from django.shortcuts import get_object_or_404, render, redirect
from django.contrib import messages
from django.contrib.auth.models import User
from django.contrib.auth import authenticate, login
from django.urls import reverse
from django.http import JsonResponse
from django.conf import settings
from django.template.loader import render_to_string, get_template
from django.core.mail import EmailMessage
from .forms import UserRegisterForm, PhoneForm, PhoneCountrys, PhoneVerificationForm, TmpPhoneForm
from backend.forms import NewPageMeta, PersonalInfoForm
from .models import Countrys, CustomerData, tmp
from advertising.models import ads
from shop.models import articles, articleprices
from landingpages.models import Page, Themes
from api.views import phone_verification
from django.views.decorators.csrf import csrf_exempt
from google.oauth2 import id_token
from google.auth.transport import requests
from django.contrib.auth import logout
from django.core.exceptions import ValidationError
from django.core.validators import validate_email
from datetime import datetime
import sys
import urllib.request as ur
import json
import random
import string
import logging
import uuid

logger = logging.getLogger('tapped_logger')


def getstartedregister(request):
    registersite = None
    if request.COOKIES.get('registersite'):
        registersite = request.COOKIES.get('registersite')
    form_phone = TmpPhoneForm()
    form_countrys = PhoneCountrys()
    return render(request, 'accounts/getstarted_register.html',
                  {'form_countrys': form_countrys, 'form_phone': form_phone, 'registersite': registersite})

def getstartedlogin(request):
    registersite = None
    if request.COOKIES.get('registersite'):
        registersite = request.COOKIES.get('registersite')
    form_phone = TmpPhoneForm()
    form_countrys = PhoneCountrys()
    return render(request, 'accounts/getstarted_login.html',
                  {'form_countrys': form_countrys, 'form_phone': form_phone, 'registersite': registersite})

def phonestart(request):
    registersite = None
    if request.COOKIES.get('registersite'):
        registersite = request.COOKIES.get('registersite')
    form_phone = TmpPhoneForm()
    form_countrys = PhoneCountrys()
    return render(request, 'accounts/phone_start.html',
                  {'form_countrys': form_countrys, 'form_phone': form_phone, 'registersite': registersite})

def indexview(request):
    if request.method == 'POST':
        if 'phonenumber' in request.POST:
            form_phone = TmpPhoneForm(request.POST)
            form_countrys = PhoneCountrys(request.POST)
            if form_phone.is_valid() and form_countrys.is_valid():
                phonenumber = form_phone.cleaned_data.get("phonenumber")
                phoneprefix = form_countrys.cleaned_data.get("phoneprefix")
                prefix = get_object_or_404(Countrys, countrycode=phoneprefix)
                fullnumber = str(prefix.prefix) + str(phonenumber)
                try:
                    object = get_object_or_404(CustomerData, phonenumber=phonenumber)
                    object.phone_code = random.randint(1111, 9999)
                    object.save()

                    phone_verification(fullnumber, object.phone_code)

                    # Saving phonenumber in session
                    request.session['auth_phonenumber'] = object.phonenumber
                    request.session['auth_fullnumber'] = fullnumber
                    request.session['authcode'] = object.phone_code

                    registereduser = True
                    newuser = False

                    if 'abusetimes' in request.session:
                        abusetimes = request.session['abusetimes']
                    else:
                        abusetimes = 0
                    if 'abusetimesemail' in request.session:
                        abusetimesemail = request.session['abusetimesemail']
                    else:
                        abusetimesemail = 0
                    return render(request, 'accounts/verification.html',
                                  {'phonenumber': fullnumber, 'registereduser': registereduser, 'newuser': newuser, 'abusetimes': abusetimes, 'abusetimesemail': abusetimesemail})
                except:
                    newuser = True
                    phonecode = random.randint(1111, 9999)

                    phone_verification(fullnumber, phonecode)

                    try:
                        object = get_object_or_404(tmp, phonenumber=phonenumber)
                        object.phone_code = phonecode
                        object.save()
                        request.session['auth_phonenumber'] = object.phonenumber
                    except:
                        tracking = None
                        if request.COOKIES.get('affiliate'):
                            tracking = request.COOKIES.get('affiliate')

                        tmpuser = tmp(phonenumber=phonenumber, phonecountry_id=phoneprefix, phone_code=phonecode, tracking=tracking)
                        tmpuser.save()
                        request.session['auth_phonenumber'] = tmpuser.phonenumber

                    request.session['auth_fullnumber'] = fullnumber
                    request.session['authcode'] = phonecode
                    if 'abusetimes' in request.session:
                        abusetimes = request.session['abusetimes']
                    else:
                        abusetimes = 0
                    return render(request, 'accounts/verification.html', {'phonenumber': fullnumber, 'abusetimes': abusetimes, 'newuser': newuser})
        else:
            ''
    if request.user.is_authenticated:
        user = request.user
        page = get_object_or_404(Page, user_id=user.id)
        return redirect(reverse('backend:pages', kwargs={'pageid': page.pageid}))
    else:
        registersite = None
        if request.COOKIES.get('registersite'):
            registersite = request.COOKIES.get('registersite')
        form_phone = TmpPhoneForm()
        form_countrys = PhoneCountrys()
        product = articles.objects.all()
        request.session['abusetimes'] = 0
        request.session['abusetimesemail'] = 0
        return render(request, 'accounts/index.html', {'form_countrys': form_countrys, 'form_phone': form_phone, 'registersite': registersite, 'product': product})


def article_detail(request, productid):
    product = get_object_or_404(articles, pk=productid)
    prices = articleprices.objects.filter(article_id=productid).order_by('sort')
    likely = articles.objects.exclude(pk=productid)
    return render(request, 'frontend/shop_detail.html', {
        'likely': likely,
        'product': product,
        'prices': prices,
    })


# ToDo: Fullnumber + tmp
def resendhandler(request):
    if request.method == 'POST':
        if "checkphone" in request.POST['type']:
            request.session['abusetimes'] = request.session['abusetimes'] + 1
            request.session.modified = True
            if request.session['abusetimes'] > 3:
                return JsonResponse({'status': 'codelimit'}, status=200)
            else:
                return JsonResponse({'status': 'ok'}, status=200)

        if "checkemail" in request.POST['type']:
            request.session['abusetimesemail'] = request.session['abusetimesemail'] + 1
            request.session.modified = True
            if request.session['abusetimesemail'] > 3:
                return JsonResponse({'status': 'codelimit'}, status=200)
            else:
                return JsonResponse({'status': 'ok'}, status=200)

        if "phone" in request.POST['type']:
            phonecode = request.session['authcode']
            fullnumber = request.session['auth_fullnumber']
            phone_verification(fullnumber, phonecode)

        elif "email" in request.POST['type']:
            # Send e-Mail to customer
            object = get_object_or_404(CustomerData, phonenumber=request.session['auth_phonenumber'])
            userobject = get_object_or_404(User, pk=object.user_id)
            context = {
                'phonecode': request.session['authcode'],
            }
            message = render_to_string('mailing/auth/authcode.html', context)
            msg = EmailMessage(
                settings.VERIFICATION_SUBJECT,
                message,
                settings.NOREPLY_NAME + "<" + settings.NOREPLY_EMAIL + ">",
                [userobject.email],
            )
            msg.content_subtype = "html"  # Main content is now text/html
            msg.send()
        return JsonResponse({'status': 'ok'}, status=200)
    return JsonResponse({'status': 'bad'}, status=200)


def verificationhandler(request):
    if request.method == 'POST':
        try:
            object = get_object_or_404(CustomerData, phonenumber=request.session['auth_phonenumber'])
            vercodedate = object.timestamp
            datenow = datetime.now()
            datedif = datenow - vercodedate
            datedifminutes = datedif.total_seconds() / 60


            # Check if code is older than 30 minutes
            if (datedifminutes >= 30):
                messages.error(request, 'Verificationcode no longer valid')
                fullnumber = request.session['auth_fullnumber']
                newuser = False
                registereduser = True
                return render(request, 'accounts/verification.html',
                              {'phonenumber': fullnumber, 'registereduser': registereduser, 'newuser': newuser})


            # Check if code is equal
            if str(object.phone_code) == str(request.POST['phone_code']) or settings.DEBUG is True and str(request.POST['phone_code']) == settings.SMS_VERIFICATIONCODE:
                object.phone_verified = 1
                object.phone_code = None
                object.save()
                newuser = False
                del request.session['auth_phonenumber']
                del request.session['auth_fullnumber']
                del request.session['authcode']

                # Login user
                user = get_object_or_404(User, id=object.user_id)
                login(request, user, backend=settings.AUTHENTICATION_BACKENDS[0])
                return redirect('/')
            else:
                fullnumber = request.session['auth_fullnumber']
                registereduser = True
                messages.error(request, 'Verificationcode invalid')
                newuser = False
                if 'abusetimesemail' in request.session:
                    abusetimesemail = request.session['abusetimesemail']
                else:
                    abusetimesemail = 0
                if 'abusetimes' in request.session:
                    abusetimes = request.session['abusetimes']
                else:
                    abusetimes = 0
                return render(request, 'accounts/verification.html',
                              {'phonenumber': fullnumber, 'registereduser': registereduser, 'newuser': newuser, 'abusetimes': abusetimes, 'abusetimesemail': abusetimesemail})

        except:
            object = get_object_or_404(tmp, phonenumber=request.session['auth_phonenumber'])

            tracking = None
            tracking = object.tracking
            vercodedate = object.timestamp
            datenow = datetime.now()
            datedif = datenow - vercodedate
            datedifminutes = datedif.total_seconds() / 60

            if (datedifminutes >= 30):
                messages.error(request, 'Verificationcode no longer valid')
                fullnumber = request.session['auth_fullnumber']
                return render(request, 'accounts/verification.html',
                              {'phonenumber': fullnumber})

            if str(object.phone_code) == str(request.POST['phone_code']) or settings.DEBUG is True and str(request.POST['phone_code']) == settings.SMS_VERIFICATIONCODE:
                object.phone_verified = 1
                object.phone_code = None
                object.save()
                form = UserRegisterForm()
                if 'third_email' in request.session:
                    phonenumber = request.session['auth_phonenumber']
                    tmpdata = get_object_or_404(tmp, phonenumber=phonenumber)
                    phoneprefix = tmpdata.phonecountry_id
                    djangouser = User(email=request.session['third_email'], username=request.session['third_id'])
                    djangouser.save()
                    createuser = CustomerData(phonenumber=phonenumber, phonecountry_id=phoneprefix, phone_code=None,
                                              user_id=djangouser.id, phone_verified=1, third_id=request.session['third_id'], third_register=request.session['third_name'], tracking=tracking)
                    createuser.save()

                    formMeta = NewPageMeta()

                    login(request, djangouser, backend=settings.AUTHENTICATION_BACKENDS[0])



                    page = formMeta.save(commit=False)
                    page.user_id = request.user.id
                    if request.COOKIES.get('registersite'):
                        page.pageid = request.COOKIES.get('registersite')

                    if request.COOKIES.get('adindex'):
                        try:
                            get_object_or_404(ads, pk=request.COOKIES.get('adindex'))
                            page.advertising_id = request.COOKIES.get('adindex')
                        except:
                            page.advertising_id = None
                    page.save()

                    personalinfoform = PersonalInfoForm()
                    personalform = personalinfoform.save(commit=False)
                    personalform.page_id = page.pageid
                    personalform.name = request.session['third_name']
                    personalform.theme = Themes.objects.all().first()
                    personalform.save()
                    tmp.objects.filter(phonenumber=phonenumber).delete()

                    del request.session['third_name']
                    del request.session['third_email']

                    response = redirect('/')
                    if request.COOKIES.get('registersite'):
                        response.delete_cookie('registersite')
                    if request.COOKIES.get('affiliate'):
                        response.delete_cookie('affiliate')

                    return response
                else:
                    return render(request, 'accounts/register.html', {'form': form})
            else:
                messages.error(request, 'Sorry, but this code is invalid.')
                fullnumber = request.session['auth_fullnumber']
                if 'abusetimes' in request.session:
                    abusetimes = request.session['abusetimes']
                else:
                    abusetimes = 0
                return render(request, 'accounts/verification.html',
                              {'phonenumber': fullnumber, 'abusetimes': abusetimes})


def register(request):
    if request.method == 'POST':
        form = UserRegisterForm(request.POST)
        fullname = request.POST['fullname']
        email = request.POST['email']
        phonenumber = request.session['auth_phonenumber']
        tmpdata = get_object_or_404(tmp, phonenumber=phonenumber)
        phoneprefix = tmpdata.phonecountry_id
        tracking = None
        tracking = tmpdata.tracking
        newuser = True
        username = uuid.uuid4().hex[:6].upper()
        password = User.objects.make_random_password()
        try:
            validate_email(email)
        except ValidationError as e:
            messages.error(request, 'E-Mail is not valid')
            return render(request, 'accounts/register.html', {'form': form})
        else:
            try:
                user = User.objects.get(email=email)
                newuser = False
                messages.error(request, 'E-Mail already taken')
                return render(request, 'accounts/register.html', {'form': form})
            except:
                ''

        if newuser:
            registeruser = User.objects.create(
                username=username,
                password=password,
                email=email
            )
            registeruser.save()

            createuser = CustomerData(phonenumber=phonenumber, phonecountry_id=phoneprefix, phone_code=None,
                                          user_id=registeruser.id, phone_verified=1, tracking=tracking)
            createuser.save()

            login(request, registeruser, backend=settings.AUTHENTICATION_BACKENDS[0])
            tmp.objects.filter(phonenumber=phonenumber).delete()
            formMeta = NewPageMeta()

            page = formMeta.save(commit=False)
            page.user_id = request.user.id
            if request.COOKIES.get('registersite'):
                page.pageid = request.COOKIES.get('registersite')
            if request.COOKIES.get('adindex'):
                try:
                    get_object_or_404(ads, pk=request.COOKIES.get('adindex'))
                    page.advertising_id = request.COOKIES.get('adindex')
                except:
                    page.advertising_id = None
            page.save()

            personalinfoform = PersonalInfoForm()
            personalform = personalinfoform.save(commit=False)
            personalform.page_id = page.pageid
            personalform.name = fullname
            personalform.theme = Themes.objects.all().first()
            personalform.save()

            response = redirect(reverse('backend:pages', kwargs={'pageid': page.pageid}))
            if request.COOKIES.get('registersite'):
                response.delete_cookie('registersite')
            if request.COOKIES.get('affiliate'):
                response.delete_cookie('affiliate')
            return response
    else:
        response = redirect('/')
        return response


def registerchip(request):
    if request.user.is_authenticated:
        return redirect('/pages')
    registersite = None
    if request.COOKIES.get('registersite'):
        registersite = request.COOKIES.get('registersite')
    if request.method == 'POST':
        if 'phonenumber' in request.POST:
            form_phone = TmpPhoneForm(request.POST)
            form_countrys = PhoneCountrys(request.POST)
            if form_phone.is_valid() and form_countrys.is_valid():
                phonenumber = form_phone.cleaned_data.get("phonenumber")
                phoneprefix = form_countrys.cleaned_data.get("phoneprefix")
                prefix = get_object_or_404(Countrys, countrycode=phoneprefix)
                fullnumber = str(prefix.prefix) + str(phonenumber)
                try:
                    object = get_object_or_404(CustomerData, phonenumber=phonenumber)
                    object.phone_code = random.randint(1111, 9999)
                    object.save()

                    phone_verification(fullnumber, object.phone_code)

                    # Saving phonenumber in session
                    request.session['auth_phonenumber'] = object.phonenumber
                    request.session['auth_fullnumber'] = fullnumber
                    request.session['authcode'] = object.phone_code

                    registereduser = True
                    newuser = False
                    if 'abusetimesemail' in request.session:
                        abusetimesemail = request.session['abusetimesemail']
                    else:
                        abusetimesemail = 0
                    if 'abusetimes' in request.session:
                        abusetimes = request.session['abusetimes']
                    else:
                        abusetimes = 0
                    return render(request, 'accounts/verification.html',
                                  {'phonenumber': fullnumber, 'registereduser': registereduser, 'newuser': newuser, 'abusetimes': abusetimes, 'abusetimesemail': abusetimesemail})
                except:
                    newuser = True
                    phonecode = random.randint(1111, 9999)
                    phone_verification(fullnumber, phonecode)

                    try:
                        object = get_object_or_404(tmp, phonenumber=phonenumber)
                        object.phone_code = phonecode
                        object.save()
                        request.session['auth_phonenumber'] = object.phonenumber
                    except:
                        tmpuser = tmp(phonenumber=phonenumber, phonecountry_id=phoneprefix, phone_code=phonecode)
                        tmpuser.save()
                        request.session['auth_phonenumber'] = tmpuser.phonenumber

                    request.session['auth_fullnumber'] = fullnumber
                    request.session['authcode'] = phonecode
                    if 'abusetimes' in request.session:
                        abusetimes = request.session['abusetimes']
                    else:
                        abusetimes = 0

                    return render(request, 'accounts/verification.html', {'phonenumber': fullnumber, 'abusetimes': abusetimes, 'newuser': newuser})
        else:
            ''
    return render(request, 'accounts/registerchip.html', {'registersite': registersite})

@csrf_exempt
def thirdlogin(request):
    body_unicode = request.body.decode('utf-8')
    data = json.loads(body_unicode)
    if 'email' in data:
        logging.error(data)
        email = data['email']
        name = data['name']
        thirdapp = data['thirdapp']
        userid = data['thirdid']

        if data['thirdapp'] == "google":
            try:
                CLIENT_ID = "901611264931-11tu7vq73lcb55bcikgebcc4l732aruv.apps.googleusercontent.com"
                token = data['token']
                idinfo = id_token.verify_oauth2_token(token, requests.Request(), CLIENT_ID)
                userid = idinfo['sub']
                if idinfo['email'] != data['email']:
                    return JsonResponse({'error': True}, status=200)
                else:
                    logger.error("Auth success")

            except ValueError:
                return JsonResponse({'error': True}, status=200)

        if data['thirdapp'] == "facebook":
            token = data['token']
            url = "https://graph.facebook.com/me?access_token={}".format(token)
            try:
                with ur.urlopen(url) as response:
                    facebookdata = json.loads(response.read())
                    if facebookdata['id'] != data['thirdid']:
                        return JsonResponse({'error1': True}, status=200)
            except:
                return JsonResponse({'error2': True}, status=200)

        # Check if User is already registered
        try:
            user = get_object_or_404(User, email=email)
            login(request, user, backend=settings.AUTHENTICATION_BACKENDS[0])

            response = JsonResponse({'auth': True}, status=200)
            response.set_cookie('authtype', thirdapp)
            return response
        except:
            request.session['third_email'] = email
            request.session['third_name'] = name
            request.session['third_id'] = userid
            request.session['third_app'] = thirdapp

            response = JsonResponse({'auth': False}, status=200)
            response.set_cookie('authtype', thirdapp)

            return response

    return JsonResponse({'error': True}, status=200)

def thirdpartyregister(request):
    if request.method == 'POST':
        form_phone = TmpPhoneForm(request.POST)
        form_countrys = PhoneCountrys(request.POST)
        if form_phone.is_valid() and form_countrys.is_valid():
            phonenumber = form_phone.cleaned_data.get("phonenumber")
            phoneprefix = form_countrys.cleaned_data.get("phoneprefix")
            prefix = get_object_or_404(Countrys, countrycode=phoneprefix)
            fullnumber = str(prefix.prefix) + str(phonenumber)
            
            request.session['auth_fullnumber'] = fullnumber

            # Check if Number is already registered
            try:
                object = get_object_or_404(CustomerData, phonenumber=phonenumber)
                messages.error(request, 'Phonenumber already taken')
                return render(request, 'accounts/register_third.html',
                              {'form_countrys': form_countrys, 'form_phone': form_phone})

            except:
                phonecode = random.randint(1111, 9999)
                phone_verification(fullnumber, phonecode)
                
                if 'abusetimes' in request.session:
                    abusetimes = request.session['abusetimes']
                else:
                    abusetimes = 0

                try:
                    object = get_object_or_404(tmp, phonenumber=phonenumber)
                    object.phone_code = phonecode
                    object.save()
                    request.session['auth_phonenumber'] = object.phonenumber
                except:
                    tracking = None
                    if request.COOKIES.get('affiliate'):
                        tracking = request.COOKIES.get('affiliate')
                    tmpuser = tmp(phonenumber=phonenumber, phonecountry_id=phoneprefix, phone_code=phonecode, tracking=tracking)
                    tmpuser.save()
                    request.session['auth_phonenumber'] = tmpuser.phonenumber

                return render(request, 'accounts/verification.html', {'phonenumber': fullnumber, 'abusetimes': abusetimes})
    else:
        if 'third_email' in request.session:
            form_phone = TmpPhoneForm()
            form_countrys = PhoneCountrys()
            return render(request, 'accounts/register_third.html', {'form_countrys': form_countrys, 'form_phone': form_phone})
        else:
            return redirect('/')

def logoutview(request):
    logout(request)
    return render(request, 'accounts/logout.html')


def indexRedirectView(request):
    if request.user.is_authenticated:
        return redirect('/pages')
    return redirect('index')
