# -*- coding: utf-8 -*-
from django.db import models
from django.contrib.auth.models import User

class Countrys(models.Model):
    countrycode = models.CharField(max_length=3, primary_key=True)
    name = models.CharField(max_length=50)
    prefix = models.CharField(max_length=4)

class CustomerData(models.Model):
    user = models.OneToOneField(User, primary_key=True, on_delete=models.CASCADE, parent_link=True, related_name='data')
    fullname = models.CharField(max_length=200, blank=True)
    phonenumber = models.BigIntegerField()
    phonecountry = models.ForeignKey(Countrys, on_delete=models.CASCADE)
    phone_code = models.IntegerField(default=None, null=True)
    email_code = models.IntegerField(default=None, null=True)
    phone_verified = models.BooleanField(default=False)
    email_verified = models.BooleanField(default=False)
    timestamp = models.DateTimeField(auto_now=True)
    stripe_customerid = models.CharField(max_length=200, blank=True)
    third_register = models.CharField(max_length=200, blank=True)
    third_id = models.CharField(max_length=200, blank=True)
    tracking = models.CharField(max_length=255, null=True)

    def getPhoneNumber(self):
        return '{}{}'.format(self.phonecountry.prefix, self.phonenumber)


class tmp(models.Model):
    phonecountry = models.ForeignKey(Countrys, on_delete=models.CASCADE)
    phonenumber = models.BigIntegerField()
    phone_verified = models.BooleanField(default=False)
    phone_code = models.IntegerField(default=None, null=True)
    timestamp = models.DateTimeField(auto_now=True)
    tracking = models.CharField(max_length=255, null=True)

    def getPhoneNumber(self):
        return '{}{}'.format(self.phonecountry.prefix, self.phonenumber)