from django import forms
from django.contrib.auth.models import User
from django.contrib.auth.forms import UserCreationForm
from django.forms import ModelForm
from accounts.models import CustomerData, Countrys, tmp

class UserRegisterForm(UserCreationForm):
    email = forms.EmailField()

    class Meta:
        model = User
        fields = ['username', 'email', 'password1', 'password2']


class TmpPhoneForm(ModelForm):
    class Meta:
        model = tmp
        fields = ['phonenumber']

class PhoneForm(ModelForm):
    class Meta:
        model = CustomerData
        fields = ['phonenumber', 'fullname']


class PhoneVerificationForm(ModelForm):
    class Meta:
        model = CustomerData
        fields = ['phone_code']


class PhoneCountrys(ModelForm):
    phoneprefix = forms.ChoiceField(choices=[(c.countrycode, c.name) for c in Countrys.objects.all()], initial='DE')
    class Meta:
        model = Countrys
        ordering = ['phoneprefix']
        fields = ('phoneprefix',)
        widgets = {
            'phoneprefix': forms.Select(attrs={'class': 'select'}),
        }

class PhoneCountrysPage(ModelForm):
    phoneprefix = forms.ChoiceField(choices=[(c.prefix, c.name) for c in Countrys.objects.all()], initial='0049')
    class Meta:
        model = Countrys
        ordering = ['phoneprefix']
        fields = ('phoneprefix',)
        widgets = {
            'phoneprefix': forms.Select(attrs={'class': 'select'}),
        }